# include "Game/Game.h"
# include "Moves/Move.h"
# include "Color.h"
# include <time.h>
//# include <unistd.h>
# include "TranspositionTable/TranspositionTable.h"
# include <CpuTimer.h>
# include <Moves/SanNotation.h>
# include <iostream>
# include <Moves/SimpleMove.h>
# include <Bitboard.h>
using namespace Alice;
void benchmark(void)
{
  const int iterations(100000);
  Game g;
  g.forsytheString("2r1nrk1/p2q1ppp/bp1p4/n1pPp3/P1P1P3/2PBB1N1/4QPPP/R4RK1/w");
  TranspositionTable ttable;
  
  long numberOfMoves(0);
  MoveList moves;
  
  g.pseudoLegalMoves(moves);
  
  for(MoveList::const_iterator it = moves.begin(); it != moves.end();
      ++ it)
    {
      SanNotation san(*it, g);
      std::cout<<san<<" ";
    }
  moves.clear();
  std::cout << std::endl;
  CpuTimer timer1;
  for (int i =0; i < iterations; i++){
    g.pseudoLegalMoves(moves);
    numberOfMoves += moves.size();
    moves.clear();
  }
  double secs = timer1.age();
  std::cout<<"generated "<<numberOfMoves<<" moves in "
	  <<secs<<" seconds, ";
  
  std::cout<<numberOfMoves/(1000*secs)<<" kMoves/sec"<<std::endl;
  std::cout<<int(1e9*secs/numberOfMoves)<<"nsec/move"<<std::endl;
  return;
  moves.clear();
  g.pseudoLegalMoves(moves);
  for (int t = 0; t < 2; t++){
    CpuTimer timer2;
    numberOfMoves = 0;
    
    for (int i =0; i < iterations; i++)
      for (MoveList::iterator it = moves.begin();
	   it != moves.end(); ++it){
	numberOfMoves ++;
	(*it)->makeOn(g);
	(*it)->takeBackOn(g);
      }
    secs = timer2.age();
    std::cout<<"made/unmade "<<numberOfMoves<<" moves in "<<secs<<" seconds, ";
    std::cout<<numberOfMoves/(1000*secs)<<" kMoves/sec"<<std::endl;
    std::cout<<int(1e9*secs/numberOfMoves)<<" nsec/move"<<std::endl;
    if (t == 0)
      {
	ttable.startObserving(&g);
	std::cout<<"with hash table: "<<std::endl;
      }
  }
  
};

int main()
{
  Board b;
  b.initialPosition();
  Bitboard bit;
  bit.getRankAttacks(0);
  benchmark();
  SimpleMove::printInfo();
  return 0;
};
